async function useToolOnEntity(bot, entityName) {
    const targetEnitity = bot.nearestEntity(entity => {
        return entity.name === entityName && entity.position.distanceTo(bot.entity.position) < 32;
    });

    if (!targetEnitity) {
        bot.chat(`I can't find ${entityName}!`);
        console.log(`I can't find ${entityName}!`);
        return;
    }

    try {
        await bot.pathfinder.goto(new GoalBlock(targetEnitity.position.x, targetEnitity.position.y, targetEnitity.position.z));
        await bot.useOn(targetEnitity);
        bot.chat(`I used on ${entityName}!`);
        console.log(`I used on ${entityName}!`);
    } catch (error) {
        console.log(error);
        
    }
    
}